-- Anniversary Edition Setup
-- for Anniversary Edition Seven
-- by Iritscen
-- For installing the Anniversary Edition Seven's AEI Updater. This script looks for an existing Oni
--	installation, places the AEInstaller2Updater into a new AE/ folder, and runs it. It also makes sure
--	that the user has Java installed so he can run the Updater and Installer. It does not check for Mono
--	because that would be redundant of the Installer itself.
-- History:
--   1.3.0 - No code changes. Re-built in order to include AEInstaller2Updater 1.3.
--   1.2.0 - No code changes. Re-built in order to include Run AE Installer 1.1.0, which had a change
--           made to ensure Mono compatibility in 10.13.
--   1.1.9 - No code changes. Re-built in order to include Run AE Installer 1.0.9, which also had no
--           code changes but needed to be re-built in 10.12 in order to run in 10.12.
--   1.1.8 - Updated "Run AE Installer" script for Mono in 10.11.
--   1.1.7 - Now an AppleScriptObjC application to ensure signing integrity and OS compatibility.
--   1.1.6 - Now testing for Java's existence before talking to it, because it seems that simply calling
--              "java -version" now causes the script to fail with an error dialog instead of invoking
--              OS X's Java installation prompt. Setup app now uses the standard icon name "applet" so
--              that Info.plist does not have to be edited, since that invalidates the code signature
--              applied by OS X 10.6's Script Editor. Some dialog text has been made clearer. Fixed a
--              weird bug that cropped up for the first time while testing this script, which was
--              breaking GDF validation.
--   1.1.5 - Now using fixed paths for Java for 10.6 and for 10.7+ because "which java" is not reliable.
--   1.1.4 - Now attempting to call Java through "java" again before falling back to looking in Internet
--              Plug-Ins, because 10.6 has Java installed differently.
--   1.1.3 - No longer supplying link to MacUpdate page for Apple Java because it is out of date; only
--              supplying link to java.com.
--   1.1.2 - Calling Java at Internet plug-in location instead of using basic command-line "java", as
--              only the JDK installs command-line Java.
--   1.1.1 - Changed the "Run AE Installer" script to set environment to UTF-8 in order to avoid 'ƒ'
--              problem in Java 7.
--   1.1   - Updated bundled AEI Updater to 1.1, which supports proxies.
--   1.0   - Initial release.

script AppDelegate
	property parent : class "NSObject"
    global pathToMe
    global sosumi
    global gNeedsJavaVersionMajor
    global gNeedsJavaVersionMinor
	
	-- IBOutlets
	property theWindow : missing value
    property aesIcon : missing value
	
	on applicationWillFinishLaunching_(aNotification)
        -- Set globals
        set gNeedsJavaVersionMajor to 1
        set gNeedsJavaVersionMinor to 6
        
        -- Set "pathToMe" for various future uses; its value will be "/path/to/Anniversary Edition Setup.app/Contents/Resources"
        tell current application's class "NSBundle"
            tell its mainBundle()
                set pathToMe to resourcePath() as string
            end tell
        end tell
        
        -- Draw the AE Setup icon in the window
        set iconPath to POSIX path of ((pathToMe & "/AppIcon.png") as string)
        set aesIconImg to current application's NSImage's alloc's initWithContentsOfFile_(iconPath)
        aesIcon's setImage_(aesIconImg)
        
        -- Set up "sosumi" with the Sosumi sound
        tell current application's NSSound to set thisSound to soundNamed_("Sosumi")
        
        -- Bring self to front in case something else stole focus
        tell me
            activate
        end tell
	end applicationWillFinishLaunching_
    
    on applicationShouldTerminateAfterLastWindowClosed_(sender)
        return true
    end applicationShouldTerminateAfterLastWindowClosed_
	
	on applicationShouldTerminate_(sender)
		-- Insert code here to do any housekeeping before your application quits 
		return current application's NSTerminateNow
	end applicationShouldTerminate_
    
    -- IBActions
    on clickStart_(sender)
        set installPath to my find_Oni_folder()
        tell me
            activate
        end tell
        if (installPath is "Gave up") then
            display dialog "Sorry, the AE currently requires a retail Oni installation." buttons {"OK"} default button 1 with title "AE Setup"
        else if (installPath is "AE exists") then
            display dialog "If you are sure you want to start over with a new AE installation in this location, then you should delete the existing AE/ folder and then run this Setup app again." buttons {"OK"} default button 1 with title "AE Setup"
        else if (installPath is "") then
            display dialog "Unknown error encountered while choosing Oni installation. Please ask for help in the Anniversary Edition sub-forum of the Oni Central Forum." buttons {"Go to forum", "OK"} default button 2 with title "AE Setup"
            set quitOrForum to button returned of the result
            if (quitOrForum is "Go to forum") then
                open location "http://oni.bungie.org/community/forum/index.php"
            end if
        else
            set installResult to my install_AEI_Updater(installPath)
            tell me
                activate
            end tell
            if (installResult is 0) then
                display dialog "Updater installed. AE Setup will now continue the installation by running the Updater." buttons {"OK"} default button 1 with title "AE Setup"
                set runResult to my run_AEIU(installPath)
                tell me
                    activate
                end tell
                -- Quit if running Run AE Installer seems to have been successful
                if (runResult is 0) then
                    tell me
                        quit
                    end tell
                else if (runResult is 1) then
                    display dialog "Script copy error. Please ask for help in the Anniversary Edition sub-forum of the Oni Central Forum." buttons {"Go to forum", "OK"} default button 2 with title "AE Setup"
                    set quitOrForum to button returned of the result
                    if (quitOrForum is "Go to forum") then
                        open location "http://oni.bungie.org/community/forum/index.php"
                    end if
                else if (runResult is 2) then
                    display dialog "Could not run AEI Updater. Please ask for help in the Anniversary Edition sub-forum of the Oni Central Forum." buttons {"Go to forum", "OK"} default button 2 with title "AE Setup"
                    set quitOrForum to button returned of the result
                    if (quitOrForum is "Go to forum") then
                        open location "http://oni.bungie.org/community/forum/index.php"
                    end if
                end if
            else if (installResult is 1) then
                display dialog "Could not install the AEI Updater because Java was not installed or new enough. Please obtain a Java installer from Java.com." buttons {"Go to Java.com", "OK"} default button 2 with title "AE Setup"
                set quitOrJava to button returned of the result
                if (quitOrJava is "Go to Java.com") then
                    open location "http://www.java.com/"
                end if
            else if (installResult is 2) then -- file operation failure
                display dialog "Could not install the AEI Updater. Please ask for help in the Anniversary Edition sub-forum of the Oni Central Forum." buttons {"Go to forum", "OK"} default button 2 with title "AE Setup"
                set quitOrForum to button returned of the result
                if (quitOrForum is "Go to forum") then
                    open location "http://oni.bungie.org/community/forum/index.php"
                end if
            else
                display dialog "Unknown error returned from install_AEI_Updater()! Please ask for help in the Anniversary Edition sub-forum of the Oni Central Forum." buttons {"Go to forum", "OK"} default button 2 with title "AE Setup"
                set quitOrForum to button returned of the result
                if (quitOrForum is "Go to forum") then
                    open location "http://oni.bungie.org/community/forum/index.php"
                end if
            end if
        end if
    end clickStart_

    -- The user must pick an acceptable folder to install the AE in, or die trying (or give up)
    -- Returns "Gave up" if user clicked Quit after being told his choice was not the Oni folder,
    -- "AE exists" if user clicked Quit after being told that the AE folder was already present, and
    -- returns the user's chosen path if validation was successful
    -- Called by clickStart_()
    on find_Oni_folder()
        tell me
            tell me
                activate
            end tell
            set tryAgain to true
            set isOniRetail to false
            set pathProblem to ""
            set folderTest to 0
            repeat while (tryAgain is true)
                set chosenPath to (choose folder with prompt "Please locate your Oni installation.")
                if (chosenPath is "") then
                    display dialog "There was an error in choosing the Oni folder." buttons {"OK"} default button 1 with title "AE Setup"
                    return chosenPath
                end if
                set folderTest to my validate_Oni_folder(chosenPath)
                tell me
                    activate
                end tell
                if (folderTest is 1) then
                    display dialog "This doesn't seem to be your Oni installation. Click \"Try again\" to locate another folder." buttons {"Cancel", "Try again"} default button 2 with title "AE Setup"
                    set cancelOrTryAgain to the button returned of the result
                    if (cancelOrTryAgain is "Cancel") then
                        set tryAgain to false
                        set pathProblem to "Gave up"
                    end if
                else if (folderTest is 2) then
                    display dialog "This Oni installation already has an AE/ folder! This means that you've probably already run this Setup app, and now you should be opening the \"Run AE Installer\" script in the AE/ folder. You can also click \"Try again\" to find another Oni installation in which to install the AE." buttons {"Cancel", "Try again"} default button 2 with title "AE Setup"
                    set cancelOrTryAgain to the button returned of the result
                    if (cancelOrTryAgain is "Cancel") then
                        set tryAgain to false
                        set pathProblem to "AE exists"
                    end if
                else
                    set tryAgain to false -- we got it, let's get out of this loop
                end if
            end repeat
            if (folderTest is 0) then
                return chosenPath
            else
                return pathProblem
            end if
        end tell
    end find_Oni_folder
    
    -- Returns 0 if this is a valid target for the AE installation,
    -- 1 if this is not a valid target, and
    -- 2 if the AE is already here
    -- Called by find_Oni_folder()
    on validate_Oni_folder(folderPath)
        tell application "Finder"
            tell me
                activate
            end tell
            -- Is the GDF here?
            if not (exists folder "GameDataFolder" in folder folderPath) then
                display dialog "GameDataFolder not detected here." buttons {"OK"} default button 1 with title "AE Setup"
                return 1
            end if
            -- Is the AE folder here? Because we won't install over it.
            if (exists folder "AE" in folder folderPath) then
                return 2
            end if
            
            -- Now see if this is the full installation or demo
            set retailLevelList to {0, 1, 2, 3, 4, 6, 8, 9, 10, 11, 12, 13, 14, 18, 19}
            set demoLevelList to {0, 1, 4} -- there's also a separate demo release of just level 2 to be dropped into the demo's GDF, but 1 and 4 were the only core demo levels
            set isRetail to true
            set isDemo to true
            -- Look for levels until one is missing and we know this isn't a complete retail release
            repeat with thisLevel in retailLevelList
                if not (exists file ((folderPath & "GameDataFolder:level" & (thisLevel as string) & "_Final.dat") as string)) then
                    set isRetail to false
                    exit repeat
                end if
            end repeat
            if (isRetail) then
                -- Don't return here if we add demo support below
                return 0
            end if
            -- Look for levels until one is missing and we know this isn't a complete demo release
            repeat with thisLevel in demoLevelList
                if not (exists file ((folderPath & "GameDataFolder:level" & (thisLevel as string) & "_Final.dat") as string)) then
                    set isDemo to false
                    exit repeat
                end if
            end repeat
            if (isDemo) then
                -- Insert handling of demo status here if we ever support a demo AE
                return 1
            else
                return 1
            end if
        end tell
    end validate_Oni_folder
    
    -- If Java is found, creates the AE/ folder with the Updater
    -- Returns 0 if the Updater was installed (which will install the Installer itself afterward),
    -- 1 if Java fails verification, and
    -- 2 if a file operation or other error occurs
    -- Called by clickStart_()
    on install_AEI_Updater(pathToOni)
        tell me
            set javaResult to my verify_Java()
            if (javaResult is 1) then
                return 1
            end if
        end tell
        -- Make "Oni/AE" folder
        tell application "Finder"
            if ((pathToOni & "AE") exists) then -- shouldn't happen because we already looked for it in validate_Oni_folder()
                display alert "AE folder already present!"
                return 2
            end if
            try
                make new folder at pathToOni with properties {name:"AE"}
                delay 0.5
                make new folder at ((pathToOni as string) & "AE") with properties {name:"AEInstaller"}
            on error
                display alert "Couldn't make AE or AEI folder!"
                return 2
            end try
            
            -- Copy AEI Updater into "AE/"
            set AEIU to POSIX file (pathToMe & "/AEInstaller2Updater.jar") as alias
            if (AEIU exists) then
                set AEIfolder to (pathToOni & "AE:AEInstaller" as string)
                try
                    duplicate file AEIU to folder AEIfolder
                on error copyError
                    return 2
                end try
            else
                display dialog "AE Installer Updater is not present in the Setup app!"
                return 2
            end if
        end tell
        return 0
    end install_AEI_Updater
    
    -- Checks for an acceptable Java installation
    -- This function was going to support a bundled JRE for those without Java,
    -- but it adds too many complications, so just make the user install it himself
    -- Returns 1 if Java is not found or too old, and
    -- 0 if Java is found and the version is acceptable
    -- Called by install_AEI_Updater()
    on verify_Java()
        tell me
            set origDelimiters to AppleScript's text item delimiters
            set OSversion to (system version of (system info) as string)
            set AppleScript's text item delimiters to "."
            
            -- Java's location is different in 10.6 than in 10.7+
            if ((second text item of OSversion) as number > 6) then
                set javaPath to "/Library/Internet\\ Plug-Ins/JavaAppletPlugin.plugin/Contents/Home/bin/java"
            else
                set javaPath to "/usr/bin/java"
            end if
            
            -- Test for Java before talking to it
            set javaExistsTest to ("if [ -f " & javaPath & " ]; then echo okay; fi") as string
            set javaExists to do shell script javaExistsTest without altering line endings
            if (javaExists is "") then
                return 1
            end if
            
            -- Get Java's version
            set javaVersionCmd to ((javaPath & " -version 2>&1") as string) -- Java's version output is sometimes on stderr, not stdout :-/
            set javaVersionText to do shell script javaVersionCmd without altering line endings
            if (javaVersionText is "") then
                return 1
            end if

            -- Isolate version number from output with format:
            (* java version "1.7.0_17"
             Java(TM) SE Runtime Environment (build 1.7.0_17-b02)
             Java HotSpot(TM) 64-Bit Server VM (build 23.7-b01, mixed mode) *)
            -- Get first line
            set AppleScript's text item delimiters to "
"
            set javaVersionText to first text item of javaVersionText
            -- Get text after first quote mark
            set AppleScript's text item delimiters to "\""
            set javaVersionText to second text item of javaVersionText
            -- Get first and second version numbers, third doesn't matter
            set AppleScript's text item delimiters to "."
            set versionMajor to first text item of javaVersionText
            set versionMinor to second text item of javaVersionText
            set AppleScript's text item delimiters to origDelimiters
            -- Inform user if Java is too old
            if (versionMajor ≥ gNeedsJavaVersionMajor) then
                if (versionMinor < gNeedsJavaVersionMinor) then
                    display dialog (("Sorry, Java v" & gNeedsJavaVersionMajor & "." & gNeedsJavaVersionMinor & " is required; found v" & versionMajor & "." & versionMinor & " instead.") as string) buttons {"OK"} default button 1 with title "AE Setup"
                    return 1
                end if
            else
                display dialog (("Sorry, Java v" & gNeedsJavaVersionMajor & "." & gNeedsJavaVersionMinor & " is required; found v" & versionMajor & "." & versionMinor & " instead.") as string) buttons {"OK"} default button 1 with title "AE Setup"
                return 1
            end if
        end tell
        return 0
    end verify_Java
    
    -- Drops an applet into the new "AE/" folder and runs it;
    -- the applet will try to run the AEI, but if it's not found,
    -- it runs the AEI Updater, which is what we want to happen
    -- so that the AEI can be installed.
    -- Returns 0 if this is a valid target for the AE installation,
    -- 1 if the applet cannot be dropped, and
    -- 2 if the applet cannot be run
    -- Called by clickStart_()
    on run_AEIU(pathToOni)
        tell application "Finder"
            -- Copy applet to AE/ that opens AEI or AEIU if AEI is not around
            set RAEI to POSIX file (pathToMe & "/Run AE Installer.app") as alias
            set pathToAE to alias ((pathToOni & "AE") as string)
            try
                duplicate RAEI to pathToAE
            on error copyError
                return 1
            end try
            set RAEI to ((pathToAE as string) & "Run AE Installer.app")
            try
                open RAEI
            on error runError
                return 2
            end try
        end tell
        return 0
    end run_AEIU
    
    on play_error_sound()
        tell sosumi
            play()
        end tell
    end play_error_sound
end script
